/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.sql.version;

import de.willuhn.logging.Logger;
import de.willuhn.sql.ScriptExecutor;
import de.willuhn.sql.version.Update;
import de.willuhn.sql.version.UpdateProvider;
import de.willuhn.util.ApplicationException;
import de.willuhn.util.ProgressMonitor;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class Updater {
    private UpdateProvider provider = null;
    private MyClassloader loader = null;
    private String encoding = System.getProperty("file.encoding", "iso-8859-1");

    public Updater(UpdateProvider provider) {
        this(provider, null);
    }

    public Updater(UpdateProvider provider, String encoding) {
        this.provider = provider;
        this.loader = new MyClassloader(provider);
        if (encoding != null) {
            this.encoding = encoding;
        }
    }

    public void execute() throws ApplicationException {
        this.execute((String)null);
    }

    public void execute(final String filepattern) throws ApplicationException {
        int i;
        int currentVersion = this.provider.getCurrentVersion();
        Logger.info("current version: " + currentVersion);
        Logger.info("searching for available updates");
        File baseDir = this.provider.getUpdatePath();
        if (!(baseDir != null && baseDir.exists() && baseDir.canRead() && baseDir.isDirectory())) {
            Logger.warn("no update dir given or not readable");
            return;
        }
        File[] files = baseDir.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                if (name == null) {
                    return false;
                }
                if (filepattern != null && !name.matches(filepattern)) {
                    return false;
                }
                return name.endsWith(".sql") || name.endsWith(".class") && name.indexOf("$") == -1;
            }
        });
        List<File> l = Arrays.asList(files);
        Collections.sort(l);
        files = l.toArray(new File[l.size()]);
        ArrayList<File> updates = new ArrayList<File>();
        int maxNumber = 0;
        for (i = 0; i < files.length; ++i) {
            File current = files[i];
            if (current.isDirectory()) continue;
            if (!current.canRead() || !current.isFile()) {
                Logger.warn("update file " + current + " not readable, skipping");
                continue;
            }
            int number = this.toNumber(current.getName());
            if (number < 0) {
                Logger.error("invalid update filename: " + current.getName() + ", skipping");
                continue;
            }
            if (number > maxNumber) {
                maxNumber = number;
            }
            if (number <= currentVersion) continue;
            updates.add(current);
        }
        if (currentVersion > maxNumber) {
            Logger.error("database version too new. actual version: " + currentVersion + ", maximum expected version: " + maxNumber);
            ProgressMonitor monitor = this.provider.getProgressMonitor();
            if (monitor != null) {
                monitor.setStatus(3);
                monitor.setStatusText("Die Datenbank wurde bereits mit einer neueren Programmversion ge\u00f6ffnet");
                return;
            }
            throw new ApplicationException("Die Datenbank wurde bereits mit einer neueren Programmversion ge\u00f6ffnet");
        }
        if (updates.size() == 0) {
            Logger.info("no new updates found");
            return;
        }
        Logger.info("found " + updates.size() + " update files");
        Logger.info("encoding: " + this.encoding);
        for (i = 0; i < updates.size(); ++i) {
            File f = (File)updates.get(i);
            this.execute(f);
            try {
                this.provider.setNewVersion(this.toNumber(f.getName()));
                continue;
            }
            catch (ApplicationException ae) {
                throw ae;
            }
            catch (Exception e) {
                throw new ApplicationException(e);
            }
        }
        Logger.info("update completed");
    }

    private int toNumber(String filename) {
        try {
            String number = filename;
            int ext = number.lastIndexOf(".");
            if (ext != -1) {
                number = number.substring(0, ext);
            }
            number = number.replaceAll("[^0-9]", "");
            return Integer.parseInt(number);
        }
        catch (Exception e) {
            Logger.error("invalid update filename: " + filename);
            return -1;
        }
    }

    private void execute(File update) throws ApplicationException {
        String filename = update.getName();
        if (filename.endsWith(".sql")) {
            Reader reader = null;
            try {
                Logger.info("  executing " + filename);
                reader = new InputStreamReader((InputStream)new BufferedInputStream(new FileInputStream(update)), this.encoding);
                ScriptExecutor.execute(reader, this.provider.getConnection(), this.provider.getProgressMonitor());
                return;
            }
            catch (Exception e) {
                throw new ApplicationException(e);
            }
            finally {
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (Exception exception) {}
                }
            }
        }
        if (filename.endsWith(".class")) {
            try {
                Class clazz = this.loader.findClass(update.getName());
                Update u = (Update)clazz.newInstance();
                Logger.info("  executing " + u.getClass().getName() + ": " + u.getName());
                u.execute(this.provider);
                return;
            }
            catch (ApplicationException ae) {
                throw ae;
            }
            catch (Exception e) {
                throw new ApplicationException(e);
            }
        }
        Logger.warn("unknown update file format: " + filename + ", skipping");
    }

    private class MyClassloader
    extends ClassLoader {
        private UpdateProvider provider;

        public MyClassloader(UpdateProvider provider) {
            super(provider.getClass().getClassLoader());
            this.provider = null;
            this.provider = provider;
        }

        public Class findClass(String name) {
            InputStream is = null;
            try {
                File f;
                if (!name.endsWith(".class")) {
                    name = name + ".class";
                }
                if (!(f = new File(this.provider.getUpdatePath(), name)).exists() || !f.canRead()) {
                    throw new Exception("unable to read " + f);
                }
                is = new FileInputStream(f);
                byte[] data = new byte[(int)f.length()];
                is.read(data);
                name = f.getName();
                name = name.substring(0, name.lastIndexOf("."));
                Class<?> clazz = this.defineClass(name, data, 0, data.length);
                return clazz;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            finally {
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (Exception exception) {}
                }
            }
        }
    }
}

